/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.util.ArrayList;
import java.util.Arrays;

public class PermissionsUtil {
    private static final String[] LOCATION_PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    private static final String[] CAMERA_PERMISSIONS = new String[]{"android.permission.CAMERA"};
    private static final String[] MICROPHONE_PERMISSIONS = new String[]{"android.permission.RECORD_AUDIO"};
    private static final String[] STORAGE_PERMISSIONS = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private static final String[] CONTACTS_PERMISSIONS = new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS", "android.permission.GET_ACCOUNTS"};

    public static boolean checkLocationPermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, new String[][]{LOCATION_PERMISSIONS});
    }

    public static boolean checkCameraPermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, new String[][]{CAMERA_PERMISSIONS});
    }

    public static boolean checkPhotoPermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, new String[][]{STORAGE_PERMISSIONS});
    }

    public static boolean checkPickImagePermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, CAMERA_PERMISSIONS, STORAGE_PERMISSIONS);
    }

    public static boolean checkShareImagePermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, new String[][]{STORAGE_PERMISSIONS});
    }

    public static boolean checkPickVideoPermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, new String[][]{STORAGE_PERMISSIONS});
    }

    public static boolean checkRecordVideoPermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, CAMERA_PERMISSIONS, STORAGE_PERMISSIONS);
    }

    public static boolean checkRecordAudioPermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, MICROPHONE_PERMISSIONS, STORAGE_PERMISSIONS);
    }

    public static boolean checkContactsPermission(@NonNull Context context) {
        return PermissionsUtil.checkPermissions(context, new String[][]{CONTACTS_PERMISSIONS});
    }

    protected static boolean checkPermissions(@NonNull Context context, String[] ... permissionsArray) {
        String[][] var2 = permissionsArray;
        int var3 = permissionsArray.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String[] permissions;
            String[] var6 = permissions = var2[var4];
            int var7 = permissions.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                String permission = var6[var8];
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void requestLocationPermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, LOCATION_PERMISSIONS);
    }

    public static void requestCameraPermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, CAMERA_PERMISSIONS);
    }

    public static void requestPhotoPermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, STORAGE_PERMISSIONS);
    }

    public static void requestPickImagePermissions(@NonNull Fragment fragment, int requestCode) {
        boolean hasCameraPermission = PermissionsUtil.checkPermissions(fragment.getContext(), new String[][]{CAMERA_PERMISSIONS});
        boolean hasStoragePermission = PermissionsUtil.checkPermissions(fragment.getContext(), new String[][]{STORAGE_PERMISSIONS});
        if (!hasCameraPermission && !hasStoragePermission) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.addAll(Arrays.asList(CAMERA_PERMISSIONS));
            temp.addAll(Arrays.asList(STORAGE_PERMISSIONS));
            String[] permissions = temp.toArray(new String[CAMERA_PERMISSIONS.length + STORAGE_PERMISSIONS.length]);
            PermissionsUtil.requestPermissions(fragment, requestCode, permissions);
        } else if (!hasCameraPermission) {
            PermissionsUtil.requestPermissions(fragment, requestCode, CAMERA_PERMISSIONS);
        } else if (!hasStoragePermission) {
            PermissionsUtil.requestPermissions(fragment, requestCode, STORAGE_PERMISSIONS);
        }
    }

    public static void requestShareImagePermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, STORAGE_PERMISSIONS);
    }

    public static void requestPickVideoPermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, PermissionsUtil.combinePermissions(new String[][]{STORAGE_PERMISSIONS}));
    }

    public static void requestRecordVideoPermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, PermissionsUtil.combinePermissions(CAMERA_PERMISSIONS, STORAGE_PERMISSIONS));
    }

    public static void requestRecordAudioPermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, PermissionsUtil.combinePermissions(MICROPHONE_PERMISSIONS, STORAGE_PERMISSIONS));
    }

    public static void requestContactsPermissions(@NonNull Fragment fragment, int requestCode) {
        PermissionsUtil.requestPermissions(fragment, requestCode, PermissionsUtil.combinePermissions(new String[][]{CONTACTS_PERMISSIONS}));
    }

    protected static void requestPermissions(@NonNull Fragment fragment, int requestCode, String[] permissions) {
        fragment.requestPermissions(permissions, requestCode);
    }

    private static String[] combinePermissions(String[] ... permissionsArray) {
        ArrayList<String> list = new ArrayList<String>();
        int size = 0;
        String[][] var3 = permissionsArray;
        int var4 = permissionsArray.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String[] permissions = var3[var5];
            size += permissions.length;
            list.addAll(Arrays.asList(permissions));
        }
        return list.toArray(new String[size]);
    }
}

