/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import android.net.Uri;
import android.text.TextUtils;
import com.ga.sdk.api.ApiException;
import com.ga.sdk.util.JsonUtil;
import com.ga.sdk.util.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.CertificatePinner;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpHelper {
    private static final Logger logger = Logger.getInstance(HttpHelper.class);
    private static final MediaType _JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType _JPEG = MediaType.parse((String)"image/jpeg");
    private static final MediaType _MPEG4 = MediaType.parse((String)"video/mp4");
    private static final MediaType _3GPP = MediaType.parse((String)"video/3gpp");
    private static final MediaType _MP3 = MediaType.parse((String)"audio/mpeg3");
    private static final MediaType MULTIPART = MediaType.parse((String)"multipart/form-data");

    public static String get(String url, Map<String, String> params, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url + HttpHelper.toQueryString(params)).get().build();
        return HttpHelper.execute(request);
    }

    public static String post(String url, Map<String, String> params, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url).post(HttpHelper.createJsonBody(params)).build();
        return HttpHelper.execute(request);
    }

    public static String postFromData(String url, Map<String, String> params, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().url(url).post(HttpHelper.createFormBody(params)).build();
        return HttpHelper.execute(request);
    }

    public static String put(String url, Map<String, String> params, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url).put(HttpHelper.createJsonBody(params)).build();
        return HttpHelper.execute(request);
    }

    public static String delete(String url, Map<String, String> params, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url + HttpHelper.toQueryString(params)).delete().build();
        return HttpHelper.execute(request);
    }

    public static String postImage(String url, String key, File file, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url).post(HttpHelper.createImageBody(key, file)).build();
        return HttpHelper.execute(request);
    }

    public static String postVideo(String url, String key, File file, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url).post(HttpHelper.createVideoBody(key, file)).build();
        return HttpHelper.execute(request);
    }

    public static String postVoice(String url, String key, File file, Map<String, String> headers) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url).post(HttpHelper.createVoiceBody(key, file)).build();
        return HttpHelper.execute(request);
    }

    public static void get(String url, Map<String, String> params, Map<String, String> headers, File file) throws Exception {
        Request request = new Request.Builder().headers(HttpHelper.getHeaders(headers)).url(url + HttpHelper.toQueryString(params)).get().build();
        HttpHelper.download(request, file);
    }

    private static Headers getHeaders(Map<String, String> headers) {
        Headers.Builder builder = new Headers.Builder();
        if (headers != null) {
            for (String key : headers.keySet()) {
                builder.set(key, headers.get(key));
            }
        }
        return builder.build();
    }

    private static String toQueryString(Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            Uri.Builder builder = new Uri.Builder();
            for (String key : params.keySet()) {
                builder.appendQueryParameter(key, params.get(key));
            }
            return "?" + builder.build().getEncodedQuery();
        }
        return "";
    }

    private static RequestBody createJsonBody(Map<String, String> params) {
        String raw = JsonUtil.mapToJsonString(params);
        RequestBody body = RequestBody.create((MediaType)_JSON, (String)raw);
        logger.v("Content-Type >> " + _JSON);
        logger.v("Body >> " + raw);
        return body;
    }

    private static RequestBody createFormBody(Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        FormBody body = builder.build();
        return body;
    }

    private static RequestBody createImageBody(String key, File file) {
        logger.v(file.getAbsolutePath() + "(" + file.length() + ")");
        RequestBody body = RequestBody.create((MediaType)_JPEG, (File)file);
        try {
            logger.v("body.contentLength() = " + body.contentLength());
        }
        catch (IOException var4) {
            logger.e(var4.getMessage(), var4);
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        return builder.setType(MULTIPART).addFormDataPart(TextUtils.isEmpty((CharSequence)key) ? "image" : key, "image.jpg", body).build();
    }

    private static RequestBody createVideoBody(String key, File file) {
        logger.v(file.getAbsolutePath() + "(" + file.length() + ")");
        RequestBody body = RequestBody.create((MediaType)_MPEG4, (File)file);
        try {
            logger.v("body.contentLength() = " + body.contentLength());
        }
        catch (IOException var4) {
            logger.e(var4.getMessage(), var4);
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        return builder.setType(MULTIPART).addFormDataPart(TextUtils.isEmpty((CharSequence)key) ? "video" : key, "video.mp4", body).build();
    }

    private static RequestBody createVoiceBody(String key, File file) {
        logger.v(file.getAbsolutePath() + "(" + file.length() + ")");
        RequestBody body = RequestBody.create((MediaType)_MP3, (File)file);
        try {
            logger.v("body.contentLength() = " + body.contentLength());
        }
        catch (IOException var4) {
            logger.e(var4.getMessage(), var4);
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        return builder.setType(MULTIPART).addFormDataPart(TextUtils.isEmpty((CharSequence)key) ? "voice" : key, "voice.mp3", body).build();
    }

    private static OkHttpClient.Builder initClient(Request request) throws Exception {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.connectTimeout(15L, TimeUnit.SECONDS);
        client.writeTimeout(15L, TimeUnit.SECONDS);
        client.readTimeout(15L, TimeUnit.SECONDS);
        if (request.isHttps()) {
            CertificatePinner certPinner = new CertificatePinner.Builder().add("cloudservice.altob.com.tw", new String[]{"sha256/vKvyrOUD+tqg1MBqKZibUyp6hUVjakU5ETr7SuE+UzA="}).add("TWCA", new String[]{"sha256/8hqbhsMMFPaPA8t81pxqFer9+neHBcQvO7+TAKjWkb0="}).add("TWCA", new String[]{"sha256/xES1tmzl1x4bXkDyc4XJXL/SSgW1b3DKwJkvD1DDN5w="}).build();
            client.certificatePinner(certPinner);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(Request request, File file) throws Exception {
        OkHttpClient.Builder client = HttpHelper.initClient(request);
        Response response = client.build().newCall(request).execute();
        logger.v("Response >> [" + response.code() + "] " + response.message());
        if (response.isSuccessful()) {
            BufferedInputStream in = null;
            FileOutputStream out = null;
            try {
                int length;
                File temp = new File(file.getParentFile(), file.getName() + ".temp");
                in = new BufferedInputStream(response.body().byteStream());
                out = new FileOutputStream(temp);
                byte[] buffer = new byte[4096];
                while ((length = in.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
                temp.renameTo(file);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException var17) {
                        var17.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException var16) {
                        var16.printStackTrace();
                    }
                }
            }
        }
        throw new ApiException(response.code(), response.message(), "");
    }

    private static String execute(Request request) throws Exception {
        String responseString2;
        OkHttpClient.Builder client = HttpHelper.initClient(request);
        for (String responseString2 : request.headers().names()) {
            logger.v("Request Header >> " + responseString2 + " = " + request.headers().get(responseString2));
        }
        Response response = null;
        try {
            response = client.build().newCall(request).execute();
        }
        catch (Exception e) {
            return "Certificate pinning failure!";
        }
        responseString2 = response.body().string();
        logger.v("Request >> [" + request.method() + "] " + request.url());
        logger.v("Response >> [" + response.code() + "] " + response.message());
        logger.v("Response >> " + responseString2);
        if (response.isSuccessful()) {
            return responseString2;
        }
        throw new ApiException(response.code(), response.message(), responseString2);
    }
}

