/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import com.ga.sdk.util.CodecUtil;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtil {
    public static String encrypt(String cleartext, byte[] seed) throws Exception {
        byte[] rawKey = CryptoUtil.getRawKey(seed);
        byte[] result = CryptoUtil.encrypt(rawKey, cleartext.getBytes("UTF-8"));
        return CodecUtil.toHex(result);
    }

    public static String decrypt(String encrypted, byte[] seed) throws Exception {
        byte[] rawKey = CryptoUtil.getRawKey(seed);
        byte[] enc = CodecUtil.toByte(encrypted);
        byte[] result = CryptoUtil.decrypt(rawKey, enc);
        return new String(result, "UTF-8");
    }

    private static AlgorithmParameterSpec getParameterSpec() {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        return ivParameterSpec;
    }

    private static byte[] getRawKey(byte[] seed) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(seed);
        byte[] keyBytes = new byte[32];
        System.arraycopy(digest.digest(), 0, keyBytes, 0, keyBytes.length);
        return keyBytes;
    }

    private static byte[] encrypt(byte[] raw, byte[] clear) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        cipher.init(1, (Key)keySpec, CryptoUtil.getParameterSpec());
        return cipher.doFinal(clear);
    }

    private static byte[] decrypt(byte[] raw, byte[] encrypted) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        cipher.init(2, (Key)keySpec, CryptoUtil.getParameterSpec());
        return cipher.doFinal(encrypted);
    }
}

