/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.parser;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseParser {
    public static boolean hasValue(@NonNull JSONObject json, @NonNull String key) {
        return json.has(key) && !json.isNull(key);
    }

    protected static boolean getBoolean(@NonNull JSONObject json, @NonNull String key) {
        return json.has(key) && json.optBoolean(key, false);
    }

    protected static double getDouble(@NonNull JSONObject json, @NonNull String key) {
        return json.has(key) ? json.optDouble(key, 0.0) : 0.0;
    }

    protected static long getLong(@NonNull JSONObject json, @NonNull String key) {
        return json.has(key) ? json.optLong(key, 0L) : 0L;
    }

    protected static int getInt(@NonNull JSONObject json, @NonNull String key) {
        return json.has(key) ? json.optInt(key, 0) : 0;
    }

    protected static float getFloat(@NonNull JSONObject json, @NonNull String key) {
        return json.has(key) ? (float)json.optDouble(key, 0.0) : 0.0f;
    }

    protected static String getString(@NonNull JSONObject json, @NonNull String key) {
        return BaseParser.hasValue(json, key) ? json.optString(key, "") : null;
    }

    protected static JSONObject getJSONObject(@NonNull JSONObject json, @NonNull String key) {
        return BaseParser.hasValue(json, key) ? json.optJSONObject(key) : null;
    }

    protected static JSONArray getJSONArray(@NonNull JSONObject json, @NonNull String key) {
        return BaseParser.hasValue(json, key) ? json.optJSONArray(key) : null;
    }

    protected static List<Integer> getIntList(@NonNull JSONObject json, @NonNull String key) throws JSONException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (BaseParser.hasValue(json, key)) {
            JSONArray dataJson = json.getJSONArray(key);
            list.addAll(BaseParser.toIntList(dataJson));
        }
        return list;
    }

    protected static List<Integer> toIntList(JSONArray jsonArray) throws JSONException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                list.add(jsonArray.getInt(i));
            }
        }
        return list;
    }

    protected static int[] getIntArray(@NonNull JSONObject json, @NonNull String key) throws JSONException {
        int[] array;
        if (json.has(key)) {
            JSONArray dataJson = json.getJSONArray(key);
            array = new int[dataJson.length()];
            for (int i = 0; i < dataJson.length(); ++i) {
                array[i] = dataJson.getInt(i);
            }
        } else {
            array = new int[]{};
        }
        return array;
    }

    protected static List<String> getStringList(@NonNull JSONObject json, @NonNull String key) throws JSONException {
        ArrayList<String> list = new ArrayList<String>();
        if (json.has(key)) {
            JSONArray dataJson = json.getJSONArray(key);
            list.addAll(BaseParser.toStringList(dataJson));
        }
        return list;
    }

    protected static List<String> toStringList(JSONArray jsonArray) throws JSONException {
        ArrayList<String> list = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                list.add(jsonArray.getString(i));
            }
        }
        return list;
    }

    protected static Map<String, String> getMap(@NonNull JSONObject json, @NonNull String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (json.has(key)) {
            JSONObject jsonObject = BaseParser.getJSONObject(json, key);
            map.putAll(BaseParser.toMap(jsonObject));
        }
        return map;
    }

    protected static Map<String, String> toMap(JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (jsonObject != null) {
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String k = (String)iterator.next();
                map.put(k, BaseParser.getString(jsonObject, k));
            }
        }
        return map;
    }

    protected static boolean validJson(String jsonString) {
        try {
            new JSONObject(jsonString);
            return true;
        }
        catch (JSONException var2) {
            return false;
        }
    }
}

