/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.loader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.fragment.app.FragmentActivity;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.ga.sdk.api.ApiException;
import com.ga.sdk.api.ApiResult;
import com.ga.sdk.common.CommonResources;
import com.ga.sdk.util.Logger;
import com.ga.sdk.util.ViewHelper;

public abstract class AbstractApiLoaderCallback<T>
implements LoaderManager.LoaderCallbacks<ApiResult<T>> {
    private static final int SC_FORBIDDEN = 403;
    private final Logger logger = Logger.getInstance(AbstractApiLoaderCallback.class);
    private final int loadId = AbstractApiLoaderCallback.genLoaderId();
    private LoaderManager loaderManager;

    @SuppressLint(value={"WrongConstant"})
    public final void onLoadFinished(Loader<ApiResult<T>> loader, ApiResult<T> result) {
        Context context = loader.getContext();
        if (this.loaderManager != null) {
            this.loaderManager.destroyLoader(loader.getId());
        }
        this.onPreLoadFinished();
        if (result.getError() != null) {
            if (!this.onApiError(result.getError()) && result.getError().getStatus() != 403) {
                try {
                    ViewHelper.showToast(context, this.toErrorMessage(result));
                }
                catch (Exception var7) {
                    int status = result.getError().getStatus();
                    String message = result.getError().getReason();
                    ViewHelper.showToast(context, "[" + status + "] " + message);
                }
            }
            if (this.isForbidden(result)) {
                this.logger.d("token incorrect or expired");
                this.handleForbidden(context);
                Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                intent.addFlags(32768);
                intent.addFlags(0x10000000);
                context.startActivity(intent);
            }
        } else if (result.getException() != null) {
            this.logger.e(result.getException().getMessage(), result.getException());
            if (!this.onException(result.getException())) {
                ViewHelper.showToast(context, CommonResources.getExceptionString(context, result.getException()));
            }
        } else {
            this.onStatusOk(result.getData());
        }
        this.onPostLoadFinished();
    }

    public void onLoaderReset(Loader<ApiResult<T>> loader) {
        this.loaderManager = null;
    }

    protected void onPreLoadFinished() {
    }

    protected abstract void onStatusOk(T var1);

    protected boolean onApiError(ApiException error) {
        return false;
    }

    protected boolean onException(Exception e) {
        return false;
    }

    protected void onPostLoadFinished() {
    }

    private void setLoaderManager(LoaderManager loaderManager) {
        this.loaderManager = loaderManager;
    }

    protected abstract String toErrorMessage(ApiResult<T> var1);

    protected boolean isForbidden(ApiResult<T> result) {
        return result.getError().getStatus() == 403;
    }

    protected abstract void handleForbidden(Context var1);

    private static int genLoaderId() {
        return (int)(Math.random() * 20000.0) + 10000;
    }

    public static void startApiLoader(LoaderManager loaderManager, AbstractApiLoaderCallback<?> callback) {
        AbstractApiLoaderCallback.startApiLoader(loaderManager, callback, (Bundle)null, true);
    }

    public static void startApiLoader(FragmentActivity activity, AbstractApiLoaderCallback<?> callback) {
        AbstractApiLoaderCallback.startApiLoader(activity.getSupportLoaderManager(), callback, (Bundle)null, true);
    }

    public static void startApiLoader(FragmentActivity activity, AbstractApiLoaderCallback<?> callback, Bundle args) {
        AbstractApiLoaderCallback.startApiLoader(activity.getSupportLoaderManager(), callback, args, true);
    }

    public static void startApiLoader(FragmentActivity activity, AbstractApiLoaderCallback<?> callback, Bundle args, boolean singleton) {
        AbstractApiLoaderCallback.startApiLoader(activity.getSupportLoaderManager(), callback, args, singleton);
    }

    private static void startApiLoader(LoaderManager loaderManager, AbstractApiLoaderCallback<?> callback, Bundle args, boolean singleton) {
        super.setLoaderManager(loaderManager);
        loaderManager.restartLoader(singleton ? callback.loadId : AbstractApiLoaderCallback.genLoaderId(), args, callback);
    }
}

