/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.format.DateUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.android.material.snackbar.Snackbar;

public class ViewHelper {
    public static void hideSoftInput(Activity activity) {
        View currentFocus;
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager.isActive() && (currentFocus = activity.getCurrentFocus()) != null) {
            inputMethodManager.hideSoftInputFromWindow(currentFocus.getWindowToken(), 2);
        }
    }

    public static void showSoftInput(Activity activity, View view) {
        View currentFocus;
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager.isActive() && (currentFocus = activity.getCurrentFocus()) != null) {
            inputMethodManager.showSoftInput(view, 1);
        }
    }

    public static Bundle makeScaleUpOptionBundle(View view) {
        return ActivityOptions.makeScaleUpAnimation((View)view, (int)0, (int)0, (int)view.getWidth(), (int)view.getHeight()).toBundle();
    }

    @SuppressLint(value={"WrongConstant"})
    public static void showToast(Context context, String message) {
        Toast.makeText((Context)context, (CharSequence)message, (int)1).show();
    }

    @SuppressLint(value={"WrongConstant"})
    public static void showToast(Context context, int rid) {
        Toast.makeText((Context)context, (int)rid, (int)1).show();
    }

    @SuppressLint(value={"WrongConstant"})
    public static void showSnackbar(View view, String message, String action, View.OnClickListener onClickListener) {
        Snackbar.make((View)view, (CharSequence)message, (int)0).setAction((CharSequence)action, onClickListener).show();
    }

    @SuppressLint(value={"WrongConstant"})
    public static void showSnackbar(View view, String message, int action, View.OnClickListener onClickListener) {
        Snackbar.make((View)view, (CharSequence)message, (int)0).setAction(action, onClickListener).show();
    }

    public static void addEditTextFilledListener(final View view, final EditText ... editTexts) {
        TextWatcher textWatcher = new TextWatcher(){

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                view.setEnabled(ViewHelper.isEditTextFilled(editTexts));
            }
        };
        boolean enable = true;
        EditText[] var4 = editTexts;
        int var5 = editTexts.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            EditText e = var4[var6];
            enable &= ViewHelper.isEditTextFilled(e);
            e.addTextChangedListener(textWatcher);
        }
        view.setEnabled(enable);
    }

    public static String getTrimText(TextView textView) {
        return textView.getText().toString().trim();
    }

    public static int getIntValue(TextView textView) {
        String text = ViewHelper.getTrimText(textView);
        return !TextUtils.isEmpty((CharSequence)text) && TextUtils.isDigitsOnly((CharSequence)text) ? Integer.parseInt(text) : 0;
    }

    public static boolean isEditTextFilled(EditText ... editTexts) {
        EditText[] var1 = editTexts;
        int var2 = editTexts.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            EditText e = var1[var3];
            if (!TextUtils.isEmpty((CharSequence)ViewHelper.getTrimText((TextView)e))) continue;
            return false;
        }
        return true;
    }

    public static int resolveAttribute(Resources.Theme theme, int attrId) {
        TypedValue typedValue = new TypedValue();
        return theme.resolveAttribute(attrId, typedValue, true) ? TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()) : 0;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }

    public static void setElapsedTime(TextView textView, long time) {
        long now = System.currentTimeMillis();
        textView.setText(DateUtils.getRelativeTimeSpanString((long)(time > now ? now : time), (long)now, (long)60000L));
    }

    public static void setText(TextView textView, String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            textView.setText((CharSequence)text);
        }
    }

    public static void cleanText(TextView ... textViews) {
        TextView[] var1 = textViews;
        int var2 = textViews.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            TextView textView = var1[var3];
            textView.setText((CharSequence)null);
        }
    }

    public static Bitmap getBitmap(ImageView imageView) {
        Drawable drawable = imageView.getDrawable();
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)imageView.getDrawable()).getBitmap();
            return bitmap;
        }
        return null;
    }
}

