/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    public static String mapToJsonString(Map<String, String> map) {
        JSONObject json = new JSONObject();
        if (map != null) {
            for (String key : map.keySet()) {
                try {
                    if (key.startsWith("{") && key.endsWith("}")) {
                        json.putOpt(JsonUtil.takeOffFix(key), (Object)new JSONObject(map.get(key)));
                        continue;
                    }
                    if (key.startsWith("[") && key.endsWith("]")) {
                        json.putOpt(JsonUtil.takeOffFix(key), (Object)new JSONArray(map.get(key)));
                        continue;
                    }
                    json.putOpt(key, (Object)map.get(key));
                }
                catch (JSONException var5) {
                    var5.printStackTrace();
                }
            }
        }
        return json.toString();
    }

    public static String mapCollectionToJsonString(Collection<Map<String, String>> collection) {
        JSONArray jsonArray = new JSONArray();
        if (collection != null) {
            for (Map<String, String> map : collection) {
                jsonArray.put((Object)new JSONObject(map));
            }
        }
        return jsonArray.toString();
    }

    public static String collectionToJsonString(Collection<String> collection) {
        JSONArray jsonArray = new JSONArray();
        if (collection != null) {
            for (String value : collection) {
                jsonArray.put((Object)value);
            }
        }
        return jsonArray.toString();
    }

    private static String takeOffFix(String s) {
        int length = s.length();
        return length > 2 ? s.substring(1, length - 1) : s;
    }
}

