/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.ga.sdk.dialog.OptionDialog;
import com.ga.sdk.util.FileUtil;
import com.ga.sdk.util.FragmentUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class IntentUtil {
    public static Intent getGalleryIntentForResult(boolean allowMultiple) {
        Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        if (allowMultiple) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        return intent;
    }

    public static Intent getCameraIntentForResult(Uri output) {
        Intent intent = new Intent();
        intent.setAction("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("android.intent.extra.videoQuality", 1);
        intent.putExtra("output", (Parcelable)output);
        return intent;
    }

    public static Intent getVideoCaptureIntentForResult(Uri output) {
        Intent intent = new Intent();
        intent.setAction("android.media.action.VIDEO_CAPTURE");
        intent.putExtra("android.intent.extra.videoQuality", 0);
        intent.putExtra("output", (Parcelable)output);
        return intent;
    }

    public static Intent getVideoIntentForResult() {
        Intent intent = new Intent();
        intent.setType("video/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        return intent;
    }

    public static Intent getVideoIntentForResult(String format) {
        Intent intent = new Intent();
        intent.setType("video/" + format);
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        return intent;
    }

    public static boolean hasImageGalleryIntentActivities(Context context) {
        return IntentUtil.hasImageGalleryIntentActivities(context, false);
    }

    public static boolean hasImageGalleryIntentActivities(Context context, boolean allowMultiple) {
        return IntentUtil.hasIntentActivities(context, IntentUtil.getGalleryIntentForResult(allowMultiple));
    }

    public static boolean hasImageCaptureIntentActivities(Context context) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        return IntentUtil.hasIntentActivities(context, intent);
    }

    public static boolean hasVideoCaptureIntentActivities(Context context) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        return IntentUtil.hasIntentActivities(context, intent);
    }

    @SuppressLint(value={"WrongConstant"})
    private static List<ResolveInfo> getIntentActivities(Context context, Intent intent) {
        PackageManager pm = context.getPackageManager();
        return pm.queryIntentActivities(intent, 65536);
    }

    private static boolean hasIntentActivities(Context context, Intent intent) {
        return IntentUtil.getIntentActivities(context, intent).size() > 0;
    }

    public static void pickImage(final Fragment fragment, final boolean allowMultiple, final Pair<Integer, String> fromGallery, final Pair<Integer, String> fromCamera) {
        boolean hasImageGalleryIntent = IntentUtil.hasImageGalleryIntentActivities((Context)fragment.getActivity());
        boolean hasImageCaptureIntent = IntentUtil.hasImageCaptureIntentActivities((Context)fragment.getActivity());
        if (hasImageGalleryIntent && hasImageCaptureIntent) {
            List<String> options = Arrays.asList((String)fromGallery.second, (String)fromCamera.second);
            OptionDialog dialog = OptionDialog.create(options, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (which == 0) {
                        IntentUtil.startImageGalleryIntent(fragment, (Integer)fromGallery.first, allowMultiple);
                    } else if (which == 1) {
                        IntentUtil.startImageCaptureIntent(fragment, (Integer)fromCamera.first);
                    }
                }
            });
            FragmentUtil.showDialog((FragmentActivity)((AppCompatActivity)fragment.getActivity()), dialog, null);
        } else if (hasImageGalleryIntent) {
            IntentUtil.startImageGalleryIntent(fragment, (Integer)fromGallery.first, allowMultiple);
        } else if (hasImageCaptureIntent) {
            IntentUtil.startImageCaptureIntent(fragment, (Integer)fromCamera.first);
        }
    }

    public static void startImageGalleryIntent(@NonNull Fragment fragment, int requestCode, boolean allowMultiple) {
        fragment.startActivityForResult(IntentUtil.getGalleryIntentForResult(allowMultiple), requestCode);
    }

    public static void startImageCaptureIntent(@NonNull Fragment fragment, int requestCode) {
        FileUtil.deleteExternalStorageTempFile();
        Uri outputUri = Uri.fromFile((File)FileUtil.getExternalStorageTempFile());
        fragment.startActivityForResult(IntentUtil.getCameraIntentForResult(outputUri), requestCode);
    }

    public static void startVideoCaptureIntent(@NonNull Fragment fragment, int requestCode, @NonNull Uri outputUri) {
        boolean hasVideoCaptureIntent = IntentUtil.hasVideoCaptureIntentActivities((Context)fragment.getActivity());
        if (hasVideoCaptureIntent) {
            fragment.startActivityForResult(IntentUtil.getVideoCaptureIntentForResult(outputUri), requestCode);
        }
    }

    public static Uri getPickImageUri(Intent intent) {
        Uri uri = intent != null && intent.getData() != null ? intent.getData() : Uri.fromFile((File)FileUtil.getExternalStorageTempFile());
        return uri;
    }

    public static Uri getDataUri(Intent intent) {
        Uri uri = intent != null && intent.getData() != null ? intent.getData() : Uri.fromFile((File)FileUtil.getExternalStorageTempFile());
        return uri;
    }

    @SuppressLint(value={"WrongConstant"})
    public static Intent getImageShareIntent(String text, Uri imageUri, @NonNull String title) {
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND");
        if (!TextUtils.isEmpty((CharSequence)text)) {
            shareIntent.putExtra("android.intent.extra.TEXT", text);
        }
        shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imageUri);
        shareIntent.setType("image/jpeg");
        shareIntent.addFlags(1);
        return Intent.createChooser((Intent)shareIntent, (CharSequence)title);
    }

    public static Intent getTextShareIntent(@NonNull String text, @NonNull String title) {
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND");
        shareIntent.putExtra("android.intent.extra.TEXT", text);
        shareIntent.setType("text/plain");
        return Intent.createChooser((Intent)shareIntent, (CharSequence)title);
    }

    public static Intent getUrlIntent(@NonNull String url) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        return intent;
    }

    public static Intent getLocationSettingIntent() {
        return new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
    }

    public static boolean isLocationEnabled(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        boolean gpsEnabled = locationManager.isProviderEnabled("gps");
        boolean networkEnabled = locationManager.isProviderEnabled("network");
        return gpsEnabled || networkEnabled;
    }
}

