/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

public class FragmentUtil {
    public static boolean containFragment(AppCompatActivity activity, int viewId) {
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        return fragmentManager.findFragmentById(viewId) != null;
    }

    @SuppressLint(value={"WrongConstant"})
    public static void add(AppCompatActivity activity, int viewId, Fragment fragment, Intent intent) {
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        if (intent != null) {
            fragment.setArguments(intent.getExtras());
        }
        fragmentTransaction.add(viewId, fragment);
        fragmentTransaction.setTransition(4099);
        fragmentTransaction.commit();
    }

    public static boolean popBackStack(Activity activity) {
        if (activity.getFragmentManager().getBackStackEntryCount() > 0) {
            activity.getFragmentManager().popBackStack();
            return true;
        }
        return false;
    }

    public static void popBackStackOrFinish(Activity activity) {
        FragmentUtil.popBackStackOrFinish(activity, null);
    }

    public static void popBackStackOrFinish(Activity activity, Intent intent) {
        if (!FragmentUtil.popBackStack(activity)) {
            if (intent != null && activity.isTaskRoot()) {
                activity.startActivity(intent);
            }
            activity.finish();
        }
    }

    public static void showDialog(FragmentActivity activity, DialogFragment dialog, Intent intent) {
        Fragment prev;
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        if (intent != null) {
            dialog.setArguments(intent.getExtras());
        }
        if ((prev = fragmentManager.findFragmentByTag("dialog")) != null) {
            fragmentTransaction.remove(prev);
        }
        dialog.show(fragmentTransaction, "dialog");
    }
}

