/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    private static final String FILE_TEMP = ".temp";

    public static File getInternalStorageFile(Context context, String fileName) {
        return new File(context.getFilesDir(), fileName);
    }

    public static File getInternalStorageFile(Context context, String parentName, String fileName) {
        File folder = new File(context.getFilesDir(), parentName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return new File(folder, fileName);
    }

    public static File getExternalStorageTempFile() {
        return FileUtil.getExternalStorageFile(FILE_TEMP);
    }

    public static void deleteExternalStorageTempFile() {
        FileUtil.deleteExternalStorageFile(FILE_TEMP);
    }

    public static File getExternalStorageFile(String fileName) {
        return new File(Environment.getExternalStorageDirectory(), fileName);
    }

    public static File getExternalStorageFile(String parentName, String fileName) {
        File folder = new File(Environment.getExternalStorageDirectory(), parentName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return new File(folder, fileName);
    }

    public static void deleteExternalStorageFile(String fileName) {
        File tempFile = FileUtil.getExternalStorageFile(fileName);
        if (tempFile.exists()) {
            tempFile.delete();
        }
    }

    public static void deleteExternalStorageFile(String parentName, String fileName) {
        File tempFile;
        File folder = new File(Environment.getExternalStorageDirectory(), parentName);
        if (folder.exists() && (tempFile = new File(folder, fileName)).exists()) {
            tempFile.delete();
        }
    }

    public static File storeExternalStorageFile(Bitmap bitmap, String fileName) throws Exception {
        return FileUtil.storeExternalStorageFile(bitmap, FileUtil.getExternalStorageFile(fileName));
    }

    public static File storeExternalStorageFile(Bitmap bitmap, String parentName, String fileName) throws Exception {
        return FileUtil.storeExternalStorageFile(bitmap, FileUtil.getExternalStorageFile(parentName, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File storeExternalStorageFile(Bitmap bitmap, File file) throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException var9) {
                    var9.printStackTrace();
                }
            }
        }
        return file;
    }

    public static File storeExternalStorageFile(File src, String fileName) throws Exception {
        return FileUtil.storeFile(src, FileUtil.getExternalStorageFile(fileName));
    }

    public static File storeExternalStorageFile(File src, String parentName, String fileName) throws Exception {
        return FileUtil.storeFile(src, FileUtil.getExternalStorageFile(parentName, fileName));
    }

    public static File storeInternalStorageFile(File src, Context context, String fileName) throws Exception {
        return FileUtil.storeFile(src, FileUtil.getInternalStorageFile(context, fileName));
    }

    public static File storeInternalStorageFile(File src, String parentName, Context context, String fileName) throws Exception {
        return FileUtil.storeFile(src, FileUtil.getInternalStorageFile(context, parentName, fileName));
    }

    public static File storeFile(File src, File file) throws Exception {
        FileUtil.storeFile((InputStream)new FileInputStream(src), new FileOutputStream(file));
        return file;
    }

    public static File storeFile(InputStream in, File file) throws Exception {
        FileUtil.storeFile(in, new FileOutputStream(file));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeFile(@NonNull InputStream in, @NonNull OutputStream out) throws Exception {
        try {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException var12) {
                var12.printStackTrace();
            }
            try {
                out.close();
            }
            catch (IOException var11) {
                var11.printStackTrace();
            }
        }
    }

    public static String getFilePathFromUri(Context context, Uri uri) {
        File file = new File(uri.getPath());
        if (file.exists()) {
            return uri.getPath();
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtil.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileUtil.isDownloadsDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(docId));
                    return FileUtil.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtil.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtil.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        }
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            return FileUtil.getDataColumn(context, uri, null, null);
        }
        return "file".equalsIgnoreCase(uri.getScheme()) ? uri.getPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Object var7;
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, (String)null);
            if (cursor != null && cursor.moveToFirst()) {
                String var8;
                int columnIndex = cursor.getColumnIndexOrThrow("_data");
                String string2 = var8 = cursor.getString(columnIndex);
                return string2;
            }
            var7 = null;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return var7;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }
}

