/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import java.util.Collection;

public class OptionDialog
extends DialogFragment {
    private static final String EXTRA_KEY_TITLE = "title";
    private static final String EXTRA_KEY_DATA = "data";
    private DialogInterface.OnClickListener onClickListener;
    protected String title;
    protected String[] data;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.title = this.getArguments().getString(EXTRA_KEY_TITLE);
            this.data = this.getArguments().getStringArray(EXTRA_KEY_DATA);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            builder.setTitle((CharSequence)this.title);
        }
        builder.setItems((CharSequence[])this.data, this.onClickListener);
        AlertDialog dialog = builder.create();
        int[] attrs = new int[]{16843534};
        TypedArray typedArray = this.getActivity().obtainStyledAttributes(attrs);
        Drawable drawableFromTheme = typedArray.getDrawable(0);
        typedArray.recycle();
        dialog.getListView().setSelector(drawableFromTheme);
        return dialog;
    }

    public void onCancel(DialogInterface dialog) {
        dialog.dismiss();
    }

    public void setOnClickListener(DialogInterface.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    public static <T> OptionDialog create(Collection<T> data, ItemConverter<T> itemHelper, DialogInterface.OnClickListener onClickListener) {
        return OptionDialog.create(null, data, itemHelper, onClickListener);
    }

    public static <T> OptionDialog create(String title, Collection<T> data, ItemConverter<T> itemHelper, DialogInterface.OnClickListener onClickListener) {
        String[] items = new String[data.size()];
        int i = 0;
        for (T t : data) {
            items[i] = itemHelper.toItemString(t);
            ++i;
        }
        return OptionDialog.create(title, items, onClickListener);
    }

    public static <T> OptionDialog create(T[] data, ItemConverter<T> itemHelper, DialogInterface.OnClickListener onClickListener) {
        return OptionDialog.create(null, data, itemHelper, onClickListener);
    }

    public static <T> OptionDialog create(String title, T[] data, ItemConverter<T> itemHelper, DialogInterface.OnClickListener onClickListener) {
        String[] items = new String[data.length];
        int i = 0;
        for (T t : data) {
            items[i] = itemHelper.toItemString(t);
            ++i;
        }
        return OptionDialog.create(title, items, onClickListener);
    }

    public static OptionDialog create(Collection<String> data, DialogInterface.OnClickListener onClickListener) {
        return OptionDialog.create(null, data, onClickListener);
    }

    public static OptionDialog create(String title, Collection<String> data, DialogInterface.OnClickListener onClickListener) {
        return OptionDialog.create(title, data.toArray(new String[data.size()]), onClickListener);
    }

    public static OptionDialog create(String[] data, DialogInterface.OnClickListener onClickListener) {
        return OptionDialog.create(null, data, onClickListener);
    }

    public static OptionDialog create(String title, String[] data, DialogInterface.OnClickListener onClickListener) {
        OptionDialog optionDialog = new OptionDialog();
        Bundle args = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            args.putString(EXTRA_KEY_TITLE, title);
        }
        args.putStringArray(EXTRA_KEY_DATA, data);
        optionDialog.setArguments(args);
        optionDialog.setOnClickListener(onClickListener);
        return optionDialog;
    }

    public static interface ItemConverter<T> {
        public String toItemString(T var1);
    }
}

