/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.fragment.app.DialogFragment;

public class CommonDialog
extends DialogFragment {
    private static final String EXTRA_KEY_MESSAGE = "message";
    private static final String EXTRA_KEY_OPTION = "option";
    private DialogInterface.OnClickListener onPositiveClickListener;
    private String positiveText;
    private String negativeText;
    protected String message;
    protected boolean hasNegative;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.message = this.getArguments().getString(EXTRA_KEY_MESSAGE);
            this.hasNegative = this.getArguments().getBoolean(EXTRA_KEY_OPTION);
        }
    }

    @SuppressLint(value={"ResourceType"})
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setMessage((CharSequence)this.message);
        if (TextUtils.isEmpty((CharSequence)this.positiveText)) {
            this.positiveText = this.getString(17039379);
        }
        if (TextUtils.isEmpty((CharSequence)this.negativeText)) {
            this.negativeText = this.getString(17039369);
        }
        builder.setPositiveButton((CharSequence)this.positiveText, this.onPositiveClickListener);
        if (this.hasNegative) {
            builder.setNegativeButton((CharSequence)this.negativeText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
        }
        return builder.create();
    }

    public void onCancel(DialogInterface dialog) {
        dialog.dismiss();
    }

    public void setOnPositiveClickListener(DialogInterface.OnClickListener onPositiveClickListener) {
        this.onPositiveClickListener = onPositiveClickListener;
    }

    public void setPositiveText(String positiveText) {
        this.positiveText = positiveText;
    }

    public void setNegativeText(String negativeText) {
        this.negativeText = negativeText;
    }

    public static CommonDialog create(String message, DialogInterface.OnClickListener onPositiveClickListener) {
        return CommonDialog.create(message, onPositiveClickListener, true);
    }

    public static CommonDialog create(String message, DialogInterface.OnClickListener onPositiveClickListener, boolean hasNegative) {
        CommonDialog optionDialog = new CommonDialog();
        Bundle args = new Bundle();
        args.putString(EXTRA_KEY_MESSAGE, message);
        args.putBoolean(EXTRA_KEY_OPTION, hasNegative);
        optionDialog.setArguments(args);
        optionDialog.setOnPositiveClickListener(onPositiveClickListener);
        return optionDialog;
    }
}

