/*
 * Decompiled with CFR 0.152.
 */
package com.ga.sdk.api;

import android.content.Context;
import com.ga.sdk.util.HttpHelper;
import java.io.File;
import java.util.Map;

public abstract class AbstractBaseApi {
    protected String accessToken;

    public <T extends AbstractBaseApi> T withAccessToken(Context context) {
        this.accessToken = this.getAccessToken(context);
        return (T)this;
    }

    protected abstract Map<String, String> getHeader();

    protected abstract String getAccessToken(Context var1);

    protected abstract String toUrl(String var1);

    protected String doGet(String path, Map<String, String> params) throws Exception {
        return HttpHelper.get(this.toUrl(path), params, this.getHeader());
    }

    protected String doPost(String path, Map<String, String> params) throws Exception {
        return HttpHelper.post(this.toUrl(path), params, this.getHeader());
    }

    protected String doPostForm(String path, Map<String, String> params) throws Exception {
        return HttpHelper.postFromData(this.toUrl(path), params, this.getHeader());
    }

    protected String doPostImage(String path, File file) throws Exception {
        return HttpHelper.postImage(this.toUrl(path), null, file, this.getHeader());
    }

    protected String doPostImage(String path, String key, File file) throws Exception {
        return HttpHelper.postImage(this.toUrl(path), key, file, this.getHeader());
    }

    protected String doPostVideo(String path, File file) throws Exception {
        return HttpHelper.postVideo(this.toUrl(path), null, file, this.getHeader());
    }

    protected String doPostVideo(String path, String key, File file) throws Exception {
        return HttpHelper.postVideo(this.toUrl(path), key, file, this.getHeader());
    }

    protected String doPostVoice(String path, File file) throws Exception {
        return HttpHelper.postVoice(this.toUrl(path), null, file, this.getHeader());
    }

    protected String doPostVoice(String path, String key, File file) throws Exception {
        return HttpHelper.postVoice(this.toUrl(path), key, file, this.getHeader());
    }

    protected String doPut(String path, Map<String, String> params) throws Exception {
        return HttpHelper.put(this.toUrl(path), params, this.getHeader());
    }

    protected String doDelete(String path, Map<String, String> params) throws Exception {
        return HttpHelper.delete(this.toUrl(path), params, this.getHeader());
    }

    protected void doDownload(String path, Map<String, String> params, File file) throws Exception {
        HttpHelper.get(this.toUrl(path), params, this.getHeader(), file);
    }
}

